/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.TFClientEvents;

@Environment(value=EnvType.CLIENT)
public class LoadingScreenGui
extends class_437 {
    private boolean isEntering;
    private boolean contentNeedsAssignment = false;
    private long ticks = 0L;
    private long seed;
    private BackgroundThemes backgroundTheme;
    private class_1799 item;
    private static final Random random = new Random();
    private static final float backgroundScale = 32.0f;
    private static final TFConfig.Client.LoadingScreen LOADING_SCREEN = TFConfig.CLIENT_CONFIG.LOADING_SCREEN;

    LoadingScreenGui() {
        super(class_333.field_18967);
    }

    void setEntering(boolean isEntering) {
        this.isEntering = isEntering;
    }

    protected void method_25426() {
        this.field_33816.clear();
        this.assignContent();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        if (this.field_22787 != null && this.field_22787.field_1687 != null && (Integer)LoadingScreenGui.LOADING_SCREEN.cycleLoadingScreenFrequency.get() != 0 && ++this.ticks % (long)((Integer)LoadingScreenGui.LOADING_SCREEN.cycleLoadingScreenFrequency.get()).intValue() == 0L) {
            this.assignContent();
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            boolean flag1;
            class_2338 blockpos = this.field_22787.field_1724.method_24515();
            boolean bl = flag1 = this.field_22787.field_1687 != null && this.field_22787.field_1687.method_31601(blockpos.method_10264());
            if (flag1 || this.field_22787.field_1769.method_40050(blockpos)) {
                this.method_25419();
            }
        }
    }

    public void method_25394(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        if (this.contentNeedsAssignment) {
            this.assignContent();
            this.contentNeedsAssignment = false;
        }
        class_327 fontRenderer = this.field_22787.field_1772;
        class_1041 resolution = this.field_22787.method_22683();
        this.drawBackground(resolution.method_4486(), resolution.method_4502());
        class_4587 stack = RenderSystem.getModelViewStack();
        RenderSystem.applyModelViewMatrix();
        this.drawBouncingWobblyItem(stack, partialTicks, resolution.method_4486(), resolution.method_4502());
        RenderSystem.applyModelViewMatrix();
        String loadTitle = class_1074.method_4662((String)("twilightforest.loading.title." + (this.isEntering ? "enter" : "leave")), (Object[])new Object[0]);
        ms.method_22903();
        ms.method_22904((double)((float)resolution.method_4486() / 2.0f - (float)fontRenderer.method_1727(loadTitle) / 4.0f), (double)((float)resolution.method_4502() / 3.0f), 0.0);
        ms.method_22904((double)(-((float)fontRenderer.method_1727(loadTitle) / 4.0f)), 0.0, 0.0);
        fontRenderer.method_1720(ms, loadTitle, 0.0f, 0.0f, 0xEEEEEE);
        ms.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void assignContent() {
        this.backgroundTheme = BackgroundThemes.values()[random.nextInt(BackgroundThemes.values().length)];
        this.item = (class_1799)LOADING_SCREEN.getLoadingScreenIcons().get(random.nextInt(LOADING_SCREEN.getLoadingScreenIcons().size()));
        this.seed = random.nextLong();
    }

    private void drawBackground(float width, float height) {
        random.setSeed(this.seed);
        this.backgroundTheme.renderBackground(width, height);
        this.backgroundTheme.postRenderBackground(width, height);
    }

    private void drawBouncingWobblyItem(class_4587 stack, float partialTicks, float width, float height) {
        float sineTicker = (TFClientEvents.sineTicker + partialTicks) * ((Double)LoadingScreenGui.LOADING_SCREEN.frequency.get()).floatValue();
        float sineTicker2 = (TFClientEvents.sineTicker + 314.0f + partialTicks) * ((Double)LoadingScreenGui.LOADING_SCREEN.frequency.get()).floatValue();
        stack.method_22903();
        stack.method_22904((double)(width - width / 30.0f * ((Double)LoadingScreenGui.LOADING_SCREEN.scale.get()).floatValue()), (double)(height - height / 10.0f), 0.0);
        if (((Boolean)LoadingScreenGui.LOADING_SCREEN.enable.get()).booleanValue()) {
            stack.method_22907(class_1160.field_20707.method_23214(class_3532.method_15374((float)(sineTicker / ((Double)LoadingScreenGui.LOADING_SCREEN.tiltRange.get()).floatValue())) * ((Double)LoadingScreenGui.LOADING_SCREEN.tiltConstant.get()).floatValue()));
            stack.method_22905((class_3532.method_15374((float)((sineTicker2 + 180.0f) / ((Double)LoadingScreenGui.LOADING_SCREEN.tiltRange.get()).floatValue() * 2.0f)) / ((Double)LoadingScreenGui.LOADING_SCREEN.scaleDeviation.get()).floatValue() + 2.0f) * (((Double)LoadingScreenGui.LOADING_SCREEN.scale.get()).floatValue() / 2.0f), (class_3532.method_15374((float)((sineTicker + 180.0f) / ((Double)LoadingScreenGui.LOADING_SCREEN.tiltRange.get()).floatValue() * 2.0f)) / ((Double)LoadingScreenGui.LOADING_SCREEN.scaleDeviation.get()).floatValue() + 2.0f) * (((Double)LoadingScreenGui.LOADING_SCREEN.scale.get()).floatValue() / 2.0f), 1.0f);
        }
        stack.method_22904(-8.0, -16.5, 0.0);
        this.field_22787.method_1480().method_4023(this.item, 0, 0);
        stack.method_22909();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BackgroundThemes {
        LABYRINTH(new class_2960[]{TwilightForestMod.prefix("textures/block/mazestone_brick.png"), TwilightForestMod.prefix("textures/block/mazestone_brick.png"), TwilightForestMod.prefix("textures/block/cracked_mazestone.png")}){
            private final class_2960 mazestoneDecor = TwilightForestMod.prefix("textures/block/decorative_mazestone.png");

            @Override
            void postRenderBackground(float width, float height) {
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                RenderSystem.setShaderTexture((int)0, (class_2960)this.mazestoneDecor);
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22912(0.0, 24.0, 0.0).method_22913(0.0f, 0.75f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, 24.0, 0.0).method_22913(width / 32.0f, 0.75f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, 8.0, 0.0).method_22913(width / 32.0f, 0.25f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912(0.0, 8.0, 0.0).method_22913(0.0f, 0.25f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                tessellator.method_1350();
                float halfScale = 16.0f;
                float bottomGrid = height - height % halfScale;
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22912(0.0, (double)bottomGrid, 0.0).method_22913(0.0f, 0.75f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)bottomGrid, 0.0).method_22913(width / 32.0f, 0.75f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)(bottomGrid - halfScale), 0.0).method_22913(width / 32.0f, 0.25f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912(0.0, (double)(bottomGrid - halfScale), 0.0).method_22913(0.0f, 0.25f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                tessellator.method_1350();
            }
        }
        ,
        STRONGHOLD(TwilightForestMod.prefix("textures/block/underbrick.png"), TwilightForestMod.prefix("textures/block/mossy_underbrick.png"), TwilightForestMod.prefix("textures/block/cracked_underbrick.png")),
        DARKTOWER(new class_2960[]{TwilightForestMod.prefix("textures/block/towerwood.png"), TwilightForestMod.prefix("textures/block/towerwood.png"), TwilightForestMod.prefix("textures/block/mossy_towerwood.png"), TwilightForestMod.prefix("textures/block/cracked_towerwood.png"), TwilightForestMod.prefix("textures/block/cracked_towerwood_alt.png")}){
            private final class_2960 towerwoodEncased = TwilightForestMod.prefix("textures/block/encased_towerwood.png");
            private final float stretch = 0.985f;
            private final float depth = 1.15f;

            @Override
            void renderBackground(float width, float height) {
                float headerDepthHeight = 37.360405f;
                float footerDepthHeight = height - 37.360405f;
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
                for (float x = 32.0f; x < width + 32.0f; x += 32.0f) {
                    for (float y = 69.360405f; y < footerDepthHeight + 32.0f; y += 32.0f) {
                        RenderSystem.setShaderTexture((int)0, (class_2960)this.getBackgroundMaterials()[random.nextInt(this.getBackgroundMaterials().length)]);
                        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                        buffer.method_22912((double)(x - 32.0f), (double)y, 0.0).method_22913(0.0f, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                        buffer.method_22912((double)x, (double)y, 0.0).method_22913(1.0f, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                        buffer.method_22912((double)x, (double)(y - 32.0f), 0.0).method_22913(1.0f, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                        buffer.method_22912((double)(x - 32.0f), (double)(y - 32.0f), 0.0).method_22913(0.0f, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                        tessellator.method_1350();
                    }
                }
            }

            @Override
            void postRenderBackground(float width, float height) {
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                RenderSystem.setShaderTexture((int)0, (class_2960)this.towerwoodEncased);
                float offset = 0.4f;
                float textureHeaderXMin = 0.985f * offset;
                float textureHeaderXMax = width / 32.0f * 0.985f + offset;
                float headerBottom = 32.48731f;
                float headerDepthHeight = 37.360405f;
                float footerTop = height - 32.48731f;
                float footerDepthHeight = height - 37.360405f;
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22912(0.0, (double)32.48731f, 0.0).method_22913(textureHeaderXMin, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)32.48731f, 0.0).method_22913(textureHeaderXMax, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, 0.0, 0.0).method_22913(textureHeaderXMax, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912(0.0, 0.0, 0.0).method_22913(textureHeaderXMin, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                tessellator.method_1350();
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22912(0.0, 37.36040496826172, 0.0).method_22913(0.0f, 1.0f).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
                buffer.method_22912((double)width, 37.36040496826172, 0.0).method_22913(width / 32.0f, 1.0f).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)32.48731f, 0.0).method_22913(textureHeaderXMax, 0.0f).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
                buffer.method_22912(0.0, (double)32.48731f, 0.0).method_22913(textureHeaderXMin, 0.0f).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
                tessellator.method_1350();
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22912(0.0, (double)height, 0.0).method_22913(textureHeaderXMin, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)height, 0.0).method_22913(textureHeaderXMax, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)footerTop, 0.0).method_22913(textureHeaderXMax, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                buffer.method_22912(0.0, (double)footerTop, 0.0).method_22913(textureHeaderXMin, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                tessellator.method_1350();
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22912(0.0, (double)footerTop, 0.0).method_22913(textureHeaderXMin, 1.0f).method_22915(0.75f, 0.75f, 0.75f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)footerTop, 0.0).method_22913(textureHeaderXMax, 1.0f).method_22915(0.75f, 0.75f, 0.75f, 1.0f).method_1344();
                buffer.method_22912((double)width, (double)footerDepthHeight, 0.0).method_22913(width / 32.0f, 0.0f).method_22915(0.75f, 0.75f, 0.75f, 1.0f).method_1344();
                buffer.method_22912(0.0, (double)footerDepthHeight, 0.0).method_22913(0.0f, 0.0f).method_22915(0.75f, 0.75f, 0.75f, 1.0f).method_1344();
                tessellator.method_1350();
            }
        }
        ,
        FINALCASTLE(new class_2960[]{TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/castle_brick.png"), TwilightForestMod.prefix("textures/block/cracked_castle_brick.png"), TwilightForestMod.prefix("textures/block/worn_castle_brick.png")}){
            private final class_2960[] magic = new class_2960[]{TwilightForestMod.prefix("textures/block/castleblock_magic_0.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_1.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_2.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_3.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_4.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_5.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_6.png"), TwilightForestMod.prefix("textures/block/castleblock_magic_7.png")};
            private final int[] colors = new int[]{0xFF00FF, 65535, 0xFFFF00, 4915330};

            @Override
            void postRenderBackground(float width, float height) {
                float x;
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                int color = this.colors[random.nextInt(this.colors.length)];
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                for (x = 32.0f; x < width + 32.0f; x += 32.0f) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)this.magic[random.nextInt(this.magic.length)]);
                    buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                    buffer.method_22912((double)(x - 32.0f), 48.0, 0.0).method_22913(0.0f, 1.0f).method_1336(r, g, b, 255).method_1344();
                    buffer.method_22912((double)x, 48.0, 0.0).method_22913(1.0f, 1.0f).method_1336(r, g, b, 255).method_1344();
                    buffer.method_22912((double)x, 16.0, 0.0).method_22913(1.0f, 0.0f).method_1336(r, g, b, 255).method_1344();
                    buffer.method_22912((double)(x - 32.0f), 16.0, 0.0).method_22913(0.0f, 0.0f).method_1336(r, g, b, 255).method_1344();
                    tessellator.method_1350();
                }
                for (x = 32.0f; x < width + 32.0f; x += 32.0f) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)this.magic[random.nextInt(this.magic.length)]);
                    buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                    buffer.method_22912((double)(x - 32.0f), (double)(height - 16.0f), 0.0).method_22913(0.0f, 1.0f).method_1336(r, g, b, 255).method_1344();
                    buffer.method_22912((double)x, (double)(height - 16.0f), 0.0).method_22913(1.0f, 1.0f).method_1336(r, g, b, 255).method_1344();
                    buffer.method_22912((double)x, (double)(height - 32.0f - 16.0f), 0.0).method_22913(1.0f, 0.0f).method_1336(r, g, b, 255).method_1344();
                    buffer.method_22912((double)(x - 32.0f), (double)(height - 32.0f - 16.0f), 0.0).method_22913(0.0f, 0.0f).method_1336(r, g, b, 255).method_1344();
                    tessellator.method_1350();
                }
            }
        };

        private final class_2960[] backgroundMaterials;

        private BackgroundThemes(class_2960 ... backgroundMaterials) {
            this.backgroundMaterials = backgroundMaterials;
        }

        class_2960[] getBackgroundMaterials() {
            return this.backgroundMaterials;
        }

        void renderBackground(float width, float height) {
            RenderSystem.setShader(class_757::method_34542);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            for (float x = 32.0f; x < width + 32.0f; x += 32.0f) {
                for (float y = 32.0f; y < height + 32.0f; y += 32.0f) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)this.getBackgroundMaterials()[random.nextInt(this.getBackgroundMaterials().length)]);
                    buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                    buffer.method_22912((double)(x - 32.0f), (double)y, 0.0).method_22913(0.0f, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                    buffer.method_22912((double)x, (double)y, 0.0).method_22913(1.0f, 1.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                    buffer.method_22912((double)x, (double)(y - 32.0f), 0.0).method_22913(1.0f, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                    buffer.method_22912((double)(x - 32.0f), (double)(y - 32.0f), 0.0).method_22913(0.0f, 0.0f).method_22915(0.5f, 0.5f, 0.5f, 1.0f).method_1344();
                    tessellator.method_1350();
                }
            }
        }

        void postRenderBackground(float width, float height) {
        }
    }
}

